function isEmpty(ob){
    for(var i in ob){ return false;}
   return true;
 }


document.addEventListener('DOMContentLoaded', async () => {

    load_pad_method();

    // select
    document.getElementById("put-none").addEventListener("change" , update_pad_method);

    document.getElementById('connect').addEventListener('click', connect);
    document.getElementById("scientist-id").addEventListener("focusout", exec_NQ2);
    document.getElementById("planet-id").addEventListener("focusout", () => exec_NQ3(document.getElementById("planet-id").value));


    document.getElementById("promote-scientist").addEventListener("click", () => exec_NQ6(true));
    document.getElementById("demote-scientist").addEventListener("click", () => exec_NQ6(false));


    document.getElementById("create-plant").addEventListener("click", () => { exec_NQ7(); });

    // sorts
    document.getElementById("sort-plant_id").addEventListener("click", () => exec_NQ9("plant_id"));
    document.getElementById("sort-latin_name").addEventListener("click", () => exec_NQ9("latin_name"));
    document.getElementById("sort-common_name").addEventListener("click", () => exec_NQ9("common_name"));
    document.getElementById("sort-is_toxic").addEventListener("click", () => exec_NQ9("is_toxic"));
    document.getElementById("sort-authorization_level").addEventListener("click", () => exec_NQ9("authorization_level"));

    document.getElementById("filter-plant-name").addEventListener("input", (event) => { exec_NQ10("name", event.target.value); });
    document.getElementById("filter-plant-is_toxic").addEventListener("change", (event) => { exec_NQ10("is_toxic", event.target.value); });
    document.getElementById("filter-plant-min_authorization_level").addEventListener("change", (event) => { exec_NQ10("min_authorization_level", event.target.value); });
    document.getElementById("filter-plant-max_authorization_level").addEventListener("change", (event) => { exec_NQ10("max_authorization_level", event.target.value); });

    document.getElementById("update-invalid-studies").addEventListener("click", () => { exec_NQ14(); });

    document.getElementById("study-plant").addEventListener("click", () => { exec_NQ12(); });

    document.getElementById("cancel-reset-password").addEventListener("click", () => { switch_to_login(); });
    document.getElementById("switch-reset-password").addEventListener("click", () => { switch_to_password_reset(); });
    document.getElementById("scientist-login").addEventListener("click", () => { exec_NQ15(); });
    document.getElementById("submit-reset-password").addEventListener("click", () => { exec_NQ16(); });

    let error_elems = document.getElementsByClassName("error");
    for (let i = 0; i < error_elems.length; i++) {
        error_elems[i].style.display = "none";
        // get the a child element
        error_elems[i].getElementsByTagName("a")[0].addEventListener('click', function(){
            error_elems[i].style.display = "none";
        });
    }


    exec_NQ4();
    exec("Q4", "/plants", GET, undefined, update_plant_select, "error-create-scientist-plants");
    await update_select_for_NQ7();
    exec_NQ14();
});

const GET = "get";
const POST = "post";
const DELETE = "delete";
const PUT = "put";

var port = 3210;
var host = "localhost";

var sort_by = "";
var sort_way = "";
var plant_filters = {};

var pad_method = "null";

var error_timeouts = {};

function update_pad_method(e){
    let value = e.target.value;
    // put in session storage
    sessionStorage.setItem("put-none", value);
    pad_method = value;
}

function load_pad_method(){
    let value = sessionStorage.getItem("put-none");
    if (value !== null){
        pad_method = value;
        document.getElementById("put-none").value = value;
    }

    document.getElementById("put-none").value = pad_method;
}

function pad(param){


    if (param === null 
    || param === undefined
    || param === ""){

        if (pad_method === "null"){
            return null;
        } else if (pad_method === "undefined"){
            return undefined;
        } else if (pad_method === "not-set"){
            return undefined;
        } else if (pad_method === "empty-string"){
            return "";
        } else if (pad_method === "empty-string-space"){
            let n = Math.random() * 5;
            let r = "";
            for (let i = 0; i < n; i++){
                if (Math.random() < 0.5) r += " ";
                else r += "\t";
            }
            return r;
        }
    }
    return param;
}
        


function create_element_from_html(html_string) {
    let template = document.createElement('template');
    template.innerHTML = html_string.trim();
    return template.content.firstChild;
}

function connect(){
    port = document.getElementById("port").value;
    host = document.getElementById("hostname").value;

    console.log("Connecting to "+host+":"+port);
    hide_errors();
    exec_NQ4();
}

function hide_errors() {
    let error_elems = document.getElementsByClassName("error");
    for (let i = 0; i < error_elems.length; i++) {
        error_elems[i].style.display = "none";
    }
}

function format_name(name) {
    if (name === null) return "--";
    return name.charAt(0).toUpperCase() + name.slice(1).toLowerCase();
}

function empty_string_to_null(str){
    if (str === undefined || str === null) return null;
    str = str.trim();
    if (str === "") return null;
    return str;
}

function clear_errors() {
    for (let id in error_timeouts) {
        let elem = document.getElementById(id);
        elem.style.display = "none";
        clearTimeout(error_timeouts[id]);
    }
    error_timeouts = {};
}

function show_error(id, message, is_success=false){ 

    if (error_timeouts[id] !== undefined){
        clearTimeout(error_timeouts[id]);
    }
    
    let elem = document.getElementById(id);
    elem.style.display = "flex";
    if (is_success) elem.classList.add("success");
    else elem.classList.remove("success");
    

    // get the span child and set its content to message
    elem.getElementsByTagName("span")[0].innerHTML = message || "An error occurred";

    error_timeouts[id] = setTimeout(() => {
        let to = error_timeouts[id];
        if (to === undefined) return;

        elem.style.display = "none";
        delete error_timeouts[id];
    }, 10000);
}


async function read_responce_text(req_name, error_id, response){
    let text = await response.text();
    let data = undefined;
    try{
        data = JSON.parse(text)
    } catch(err){
        data = text;
    };
    return data;
}


function exec(req_name, route, method, body, on_success, error_id, on_error){
    let url = "http://"+host+":"+port+route;

    console.log("[DEBUG] Sending "+method+" request "+req_name+": " + url);
    if (body !== undefined)
        console.log("[DEBUG] \t > Request body: ", body);

    let header = {
        method: method,
        headers: {
            'Content-Type': 'application/json'
        }
    }

    if (method.toLowerCase() === "post" || method.toLowerCase() === "delete" || method.toLowerCase() === "put"){
        header.body = JSON.stringify(body);
    }

    fetch(url, header).then(async response => {
        if (!response.ok) {
            // read body of the response
            let data = await read_responce_text(req_name, error_id, response);
            if (data && data.error){
                show_error(error_id, "["+method.toUpperCase()+"] "+route+" returned error: "+ response.status + " (" + response.statusText+ "): " + data.error);
            } else {
                show_error(error_id, "["+method.toUpperCase()+"] "+route+" returned error: "+ response.status + " (" + response.statusText+ ").");
            }
            console.log("[DEBUG] Response from "+req_name+": ", data);
            if (on_error !== undefined) on_error(data.data);
            console.log(" ");
            return;
        }

        let text = await response.text();
        let data = undefined;
        try{
            data = JSON.parse(text)
        } catch(err){
            console.log("[DEBUG] Response from "+req_name+": \""+ text + "\"");
            console.log(" ");
            show_error(error_id, "["+method.toUpperCase()+"] "+route+" returned error: Response do not contain valid JSON (Check console for details)");
            if (on_error !== undefined) on_error(undefined);
            return;
        };

        if (data.error){
            show_error(error_id, "["+method.toUpperCase()+"] "+route+" returned error: "+ response.status + " (" + response.statusText+ "): " + data.error);
            console.log("[DEBUG] Response from "+req_name+": ", data);
            console.log(" ");
            if (on_error !== undefined) on_error(data.data);
        } else {
            try{
                console.log("[DEBUG] Response from "+req_name+": ", data);
                on_success(data.data);
                console.log(" ");

            } catch(err){
                console.log("[DEBUG] Response from "+req_name+": ", data);
                show_error(error_id, "["+method.toUpperCase()+"] "+route+" returned error: Response format incorrectly formatted (Check console for details)");
                if (on_error !== undefined) on_error(data.data);
                console.error("[DEBUG] ", err);
                console.log(" ");
            }
        }
    }).catch(err => {
        show_error(error_id, "["+method.toUpperCase()+"] "+route+" Network error: " + err.message);
        if (on_error !== undefined) on_error(undefined);
        console.log(" ");
    });
}


// |====================================================================================================================
// | Q1 - Retrieve all planets
// |====================================================================================================================

function exec_NQ1(error_id) {
    if (error_id === undefined) error_id = "error-planets";

    return new Promise((resolve, reject) => {
        exec("Q1", "/planets", GET, undefined, (data) => {
            resolve(data);
        }, error_id);
    });
}


// |====================================================================================================================
// | Q2 - Retrieve scientist by ID and display their details
// |====================================================================================================================

function exec_NQ2(){
    let scientist_id = pad(document.getElementById("scientist-id").value);
    exec("Q2", "/scientist?id="+scientist_id, GET, undefined, display_NQ2, "error-scientist");
}

function display_NQ2(scientist){
    let container = document.getElementById("result-Q2");
    container.style.display = "flex";

    document.getElementById("scientist-username").innerText = format_name(scientist.username);
    document.getElementById("scientist-email").innerText = scientist.email;
    document.getElementById("scientist-authorization_level").innerText = scientist.authorization_level;
    document.getElementById("scientist-authorization_level-container").className = "access-level level-" + scientist.authorization_level;
    document.getElementById("scientist-user_id").innerText = "BBI-" + scientist.user_id;
    

    setTimeout(() => { exec_NQ5(scientist.user_id); }, 100);
}

// |====================================================================================================================
// | Q3 - Retrieve planet by ID and display its details
// |====================================================================================================================

function exec_NQ3(planet_id){
    document.getElementById("planet-id").value = planet_id;
    exec("Q3", "/planet/"+planet_id, GET, undefined, display_NQ3, "error-planet");
}

function display_NQ3(planet){
    let container = document.getElementById("result-Q3");
    container.style.display = "flex";

    document.getElementById("planet-name").innerText = format_name(planet.name);
    document.getElementById("planet-galaxy").innerText = format_name(planet.galaxy);
    document.getElementById("planet-atmosphere_type").innerText = planet.atmosphere_type;
    document.getElementById("planet-temperature").innerText = planet.temperature + " °C";
    document.getElementById("planet-img").src = "./planets/" + (planet.planet_id % 7) + ".png";
}



// |====================================================================================================================
// | Q4 - Retrieve and display all plants
// |====================================================================================================================

function exec_NQ4(){
    let route = "/plants";

    let sort = "";
    if (sort_by !== undefined && sort_by !== ""){
        sort += "sort_by="+sort_by+"&sort_way="+sort_way;
    }

    let filters = "";
    let i = 0;
    for (let [field, value] of Object.entries(plant_filters)){
        if (i > 0) filters += "&";
        filters += "filter_"+field+"="+value;
        i++;
    }

    if (sort !== "" || filters !== ""){
        route += "?";
        if (sort !== ""){
            route += sort;
            if (filters !== "") route += "&";
        }
        if (filters !== ""){
            route += filters;
        }
    }

    exec("Q4", route, GET, undefined, display_NQ4, "error-plants");
}

function display_NQ4(plants) {
    let table = document.getElementById("plants-table");
    let header = table.getElementsByTagName("thead")[0];
    let body = table.getElementsByTagName("tbody")[0];
    body.innerHTML = "";
    

    for (let plant of plants) {
        
        let row = body.insertRow();
        make_table_row(row, plant.plant_id, plant.latin_name, plant.common_name, plant.is_toxic, plant.authorization_level, plant.planet_id, plant.planet_name);
    }
}

function make_table_row(row, plant_id, latin_name, common_name, is_toxic, authorization_level, planet_id, planet_name){
    row.innerHTML = "";
    row.insertCell().innerText = plant_id;
    row.insertCell().innerText = format_name(latin_name);
    row.insertCell().innerText = format_name(common_name);
    row.insertCell().innerText = is_toxic === null ? "--" : (is_toxic ? "Oui" : "Non");
    row.insertCell().innerText = authorization_level == null ? "--" : authorization_level;

    if (planet_id === null){
        let cell = row.insertCell()
        cell.innerHTML = "--";
    } else {
        let btn_planet = document.createElement("a");
        btn_planet.innerHTML = "<span>"+planet_name +"</span><span class='material-symbols-outlined'>arrow_forward_ios</span>" 
        btn_planet.className = "btn btn-valid";
        btn_planet.addEventListener("click", () => {
            exec_NQ3(planet_id)
            document.getElementById("result-Q3").scrollIntoView();
        });

        let cell = row.insertCell()
        cell.appendChild(btn_planet); 
        cell.setAttribute("data-planet-id", planet_id);
    }

    let div = document.createElement("div");
    let btn_edit = document.createElement("a");
        btn_edit.innerText = "edit"
        btn_edit.className = "btn btn-alert material-symbols-outlined";
        btn_edit.addEventListener("click", () => {
            toggle_edit_plant(row, plant_id);
        });

    let btn_delete = document.createElement("a");
    btn_delete.innerText = "delete"
    btn_delete.className = "btn btn-delete material-symbols-outlined";
    btn_delete.addEventListener("click", () => {
        exec_NQ8(plant_id)
    });

    div.appendChild(btn_edit);
    div.appendChild(btn_delete);

    row.insertCell().appendChild(div);
}

// |====================================================================================================================
// | Q5 - Retrieve and display all plants of a scientist
// |====================================================================================================================


function exec_NQ5(scientist_id){
    scientist_id = pad(scientist_id);
    exec("Q5", "/scientist-plants?id="+scientist_id, GET, undefined, display_NQ5, "error-scientist-plants");
}

function display_NQ5(plants){

    container = document.getElementById("result-Q5")
    container.innerHTML = "";
    
    for (let i = 0; i < plants.length; i++) {
        const plant = plants[i];

        let tile = create_element_from_html(`
            <div class="plant-tile">
                <a class="btn btn-delete material-symbols-outlined plant-delete-btn">close</a>
                <h3 class="plant-latin-name">${format_name(plant.latin_name)}</h3>
                <img class="plant-image" src="./plants/${plant.plant_id%9}.png" alt="Image of ${format_name(plant.latin_name)}">
                <p class="plant-is-toxic">Toxique: ${plant.is_toxic ? "Oui" : "Non"}</p>
                <p class="access-level level-${plant.authorization_level}">Autorisation : ${plant.authorization_level}</p>
            </div>
        `);

        let btn_delete = tile.getElementsByClassName("plant-delete-btn")[0];
        btn_delete.addEventListener("click", () => {
            exec_NQ13(plant.plant_id)
        });


        container.appendChild(tile);
    }

    if (plants.length === 0){
        container.innerHTML = "<p>Aucune plante associée à ce scientifique.</p>";
    }
}

// |====================================================================================================================
// | Q6 - Promote/Demote scientist
// |====================================================================================================================

var new_scientist_level = 0;
function exec_NQ6(promote){
    let scientist_id = document.getElementById("scientist-id").value;
    let actual_level = parseInt(document.getElementById("scientist-authorization_level").innerText);
    if (promote) actual_level += 1;
    else actual_level -=1;
    new_scientist_level = actual_level;

    let data = {scientist_id: pad(scientist_id), authorization_level: pad(actual_level)};
    if (pad_method == "not-set"){
        if (data["scientist_id"] === undefined) delete data["scientist_id"];
        if (data["authorization_level"] === undefined) delete data["authorization_level"];
    }
    

    exec("Q6", "/scientist", PUT, data, display_NQ6, "error-scientist");
}

function display_NQ6(data){
    if (data === undefined || data.message === undefined || data.message !== "Scientist authorization level updated successfully"){
        show_error("error-scientist", "error: Response format incorrectly formatted (Check console for details)");
        return;
    }
    document.getElementById("scientist-authorization_level").innerText = new_scientist_level;
    document.getElementById("scientist-authorization_level-container").className = "access-level level-" + new_scientist_level;
}

// |====================================================================================================================
// | Q7 - Create new plant
// |====================================================================================================================

async function update_select_for_NQ7(){
    
    let planets = await exec_NQ1("error-create-plant");
    let select = document.getElementById("new-plant-planet_id");
    select.innerHTML = "";

    let option_none = document.createElement("option");
    option_none.value = "";
    option_none.innerText = "None";
    select.appendChild(option_none);

    for (let planet of planets){
        let option = document.createElement("option");
        option.value = planet.planet_id;
        option.innerText = format_name(planet.name) + " (ID: " + planet.planet_id + ")";
        select.appendChild(option);
    }

    let option_current = document.createElement("option");
    option_current.value = "999";
    option_current.innerText = "Non-existing planet (ID: 999)";
    select.appendChild(option_current);
    

}

function exec_NQ7(){

    let data = {}

    data["latin_name"] = pad(document.getElementById("new-plant-latin_name").value.trim());
    data["common_name"] = pad(document.getElementById("new-plant-common_name").value.trim());
    data["is_toxic"] = pad(document.getElementById("new-plant-is_toxic").value);
    data["authorization_level"] = parseInt(document.getElementById("new-plant-authorization_level").value);
    data["planet_id"] = pad(document.getElementById("new-plant-planet_id").value);

    if (pad_method == "not-set"){
        if (data["latin_name"] === undefined) delete data["latin_name"];
        if (data["common_name"] === undefined) delete data["common_name"];
        if (data["is_toxic"] === undefined) delete data["is_toxic"];
        if (data["authorization_level"] === undefined || isNaN(data["authorization_level"])) delete data["authorization_level"];
        if (data["planet_id"] === undefined) delete data["planet_id"];
    }


    exec("Q7", "/plant", POST, data, display_NQ7, "error-create-plant");
}

function display_NQ7(data){
    // clear inputs
    // document.getElementById("new-plant-latin_name").value = "";
    // document.getElementById("new-plant-common_name").value = "";
    // document.getElementById("new-plant-is_toxic").value = "";
    // document.getElementById("new-plant-authorization_level").value = "";
    // document.getElementById("new-plant-planet_id").value = "";

    if (data === undefined || data.message === undefined || data.message !== "Plant added successfully" ||
        data.plant_id === undefined){
        show_error("error-create-plant", "error: Response format incorrectly formatted (Check console for details)");
        return;
    }
    show_error("error-create-plant", "Plant added successfully with ID: " + data.plant_id, true);

    setTimeout(() => { exec_NQ4(); }, 100);
}


// |====================================================================================================================
// | Q8 - Delete plant by ID
// |====================================================================================================================

function exec_NQ8(plant_id){
    exec("Q8", "/plant", DELETE, {id:pad(plant_id)}, display_NQ8, "error-plants");
}

function display_NQ8(data){
    if (data === undefined || data.message === undefined || data.message !== "Plant deleted successfully"){
        show_error("error-plants", "error: Response format incorrectly formatted (Check console for details)");
        return;
    }
    show_error("error-plants", "Plant deleted successfully", true);
    setTimeout(() => { exec_NQ4(); }, 300);
}

// |====================================================================================================================
// | Q9 - Sorting plants 
// |====================================================================================================================

function exec_NQ9(field){

    // clear other sorts
    if (sort_by != "" && sort_by != field){
        document.getElementById("sort-"+sort_by).innerHTML = "unfold_more";
    }
    sort_way = "";
    sort_btn = document.getElementById("sort-"+field);
    if (sort_btn.innerHTML == "unfold_more"){
        sort_way = "asc";
        sort_by = field;
        sort_btn.innerHTML = "arrow_downward";
    } else if (sort_btn.innerHTML == "arrow_downward"){
        sort_way = "desc";
        sort_by = field;
        sort_btn.innerHTML = "arrow_upward";
    } else {
        sort_btn.innerHTML = "unfold_more";
        sort_by = "";
    }
    
    exec_NQ4();
}



// |====================================================================================================================
// | Q10 - Filters for plants
// |====================================================================================================================

function exec_NQ10(field, value){
    if (value === "" || value === null){
        delete plant_filters[field];
    } else plant_filters[field] = value;
    
    exec_NQ4();
}



// |====================================================================================================================
// | Q11 - Edit plant characteristics
// |====================================================================================================================
var editing_plant_row = undefined;
var edtiting_plant_original_data = undefined;
var editting_plant_new_data = undefined;

async function toggle_edit_plant(row, plant_id){
    untoggle_edit_plant();

    let planet_id = row.cells[5].getAttribute("data-planet-id");
    let planet_name = "";
    
    if (planet_id !== null) planet_name = row.cells[5].children[0].children[0].innerText;
    
    editing_plant_row = row;
    edtiting_plant_original_data = {
        plant_id: plant_id,
        latin_name: row.cells[1].innerText,
        common_name: row.cells[2].innerText,
        is_toxic: row.cells[3].innerText === "Oui",
        authorization_level: row.cells[4].innerText,
        planet_id: planet_id,
        planet_name: planet_name
    };
    editting_plant_new_data = {};

    let latin_name_input = create_input("text", row.cells[1].innerText);
    latin_name_input.addEventListener("focusout", () => { editting_plant_new_data["latin_name"] = pad(latin_name_input.value); });

    let common_name_input = create_input("text", row.cells[2].innerText);
    common_name_input.addEventListener("focusout", () => { editting_plant_new_data["common_name"] = pad(common_name_input.value); });

    let is_toxic_input = create_input("checkbox", "", row.cells[3].innerText === "Oui");
    is_toxic_input.addEventListener("change", () => { editting_plant_new_data["is_toxic"] = is_toxic_input.checked; });

    let authorization_level_input = create_input("number", row.cells[4].innerText);
    authorization_level_input.addEventListener("focusout", () => { editting_plant_new_data["authorization_level"] = pad(authorization_level_input.value); });

    // select
    let planet_data = await exec_NQ1("error-plants");
    let planet_id_input = document.createElement("select");
    let option_none = document.createElement("option");
    option_none.value = "";
    option_none.innerText = "None";
    planet_id_input.appendChild(option_none);
    for (let planet of planet_data){
        let option = document.createElement("option");
        option.value = planet.planet_id;
        option.innerText = format_name(planet.name) + " (ID: " + planet.planet_id + ")";
        if (row.cells[5].getAttribute("data-planet-id") == planet.planet_id){
            option.selected = true;
        }
        planet_id_input.appendChild(option);
    }
    let option_current = document.createElement("option");
    option_current.value = "999";
    option_current.innerText = "Non-existing planet (ID: 999)";
    planet_id_input.appendChild(option_current);

    planet_id_input.addEventListener("change", () => { editting_plant_new_data["planet_id"] = (planet_id_input.value === "" ? null : planet_id_input.value); });


    let btn_save = document.createElement("a");
    btn_save.innerText = "check"
    btn_save.className = "btn btn-valid material-symbols-outlined";
    btn_save.addEventListener("click", exec_NQ11);

    row.cells[1].innerText = "";
    row.cells[1].appendChild(latin_name_input);
    row.cells[2].innerText = "";
    row.cells[2].appendChild(common_name_input);
    row.cells[3].innerText = "";
    row.cells[3].appendChild(is_toxic_input);
    row.cells[4].innerText = "";
    row.cells[4].appendChild(authorization_level_input);
    row.cells[5].innerText = "";
    row.cells[5].appendChild(planet_id_input);
    row.cells[6].innerHTML = "";
    row.cells[6].appendChild(btn_save);
}


function untoggle_edit_plant(){
    if (editing_plant_row !== undefined){
        let p = edtiting_plant_original_data;
        make_table_row(editing_plant_row, p.plant_id, p.latin_name, p.common_name, p.is_toxic, p.authorization_level, p.planet_id, p.planet_name);
    }
    editing_plant_row = undefined;
    edtiting_plant_original_data = undefined;
    editting_plant_new_data = undefined;
}

function exec_NQ11() {
    let plant_id = edtiting_plant_original_data.plant_id;
    
    if (isEmpty(editting_plant_new_data)){
        untoggle_edit_plant();
        return;
    }

    editting_plant_new_data["id"] = plant_id;
    exec("Q11", "/plant", PUT, editting_plant_new_data, (data) => {
        display_NQ11(true, data);
    }, "error-plants", (data) => {
        display_NQ11(false, data);
    });
}

function get_planet_data(planet_id, error_id){
    return new Promise((resolve, reject) => {
        exec("G3", "/planet/"+planet_id, GET, undefined, (data) => {
            resolve(data);
        }, error_id, (data) => {
            reject(data);
        });
    });
}

async function display_NQ11(ok, data){
    if (ok){
        if (data === undefined || data.message === undefined || data.message !== "Plant updated successfully")
        {
            show_error("error-plants", "error: Response format incorrectly formatted (Check console for details)");
        }
        else
        {
            for (let [key, value] of Object.entries(editting_plant_new_data)){
                edtiting_plant_original_data[key] = value;
            }
    
            if ("planet_id" in editting_plant_new_data && editting_plant_new_data["planet_id"] !== null){
                let data = await get_planet_data(edtiting_plant_original_data.planet_id, "error-plants");
                edtiting_plant_original_data.planet_name = data.name;
            }
        }
    }
    untoggle_edit_plant();
}

// |====================================================================================================================
// | Q12 - Add plant to scientist's collection
// |====================================================================================================================


function update_plant_select(plants){

    let plant_select = document.getElementById("scientist-plant-select");
    plant_select.innerHTML = "<option value=''>Select a plant</option>";
    for (let plant of plants) {
        let option = document.createElement("option");
        option.value = plant.plant_id;
        option.innerText = format_name(plant.latin_name) + " (ID: " + plant.plant_id + ")";
        plant_select.appendChild(option);
    }
    let option = document.createElement("option");
    option.value = "999";
    option.innerText = "Non-existing plant (ID: 999)";
    plant_select.appendChild(option);
}


function exec_NQ12(){
    let scientist_id = pad(document.getElementById("scientist-id").value);
    let plant_id = pad(document.getElementById("scientist-plant-select").value);
    let data = {scientist_id: scientist_id, plant_id: plant_id};
    if (pad_method == "not-set"){
        if (data["scientist_id"] === undefined) delete data["scientist_id"];
        if (data["plant_id"] === undefined) delete data["plant_id"];
    }

    exec("Q12", "/scientist-plant", PUT, data, display_NQ12, "error-create-scientist-plants");
}

function display_NQ12(data){
    if (data === undefined || data.message === undefined || data.message !== "Scientist-Plant association added successfully"){
        show_error("error-create-scientist-plants", "error: Response format incorrectly formatted (Check console for details)");
        return;
    }
    let scientist_id = document.getElementById("scientist-id").value;
    setTimeout(() => { exec_NQ5(scientist_id); }, 100);
}

// |====================================================================================================================
// | Q13 - Delete plant from scientist's collection
// |====================================================================================================================

function exec_NQ13(plant_id){
    let scientist_id = pad(document.getElementById("scientist-id").value);
    data = {scientist_id: scientist_id, plant_id: plant_id};
    if (pad_method == "not-set"){
        if (data["scientist_id"] === undefined) delete data["scientist_id"];
        if (data["plant_id"] === undefined) delete data["plant_id"];
    }
    exec("Q13", "/scientist-plant", DELETE, {scientist_id: scientist_id, plant_id: plant_id}, display_NQ13, "error-scientist-plants");
}

function display_NQ13(data){
    if (data === undefined || data.message === undefined || data.message !== "Scientist-Plant association deleted successfully"){
        show_error("error-scientist-plants", "error: Response format incorrectly formatted (Check console for details)");
        return;
    }

    let scientist_id = document.getElementById("scientist-id").value;
    setTimeout(() => { exec_NQ5(scientist_id); }, 300);
}



function create_input(type, value, checked=false){
    let input = document.createElement("input");
    input.type = type;
    value = value.trim();
    if (value === undefined || value === null || value ==="--") value = "";
    input.value = value;
    if (type === "checkbox"){
        input.checked = checked;
    }
    return input;
}


// |====================================================================================================================
// | Q14 - Scientists with invalid studies
// |====================================================================================================================

function exec_NQ14(){
    exec("Q14", "/invalid-studies", GET, undefined, display_NQ14, "error-invalid-studies");
}

// return {user_id, username, authorization_level, plants_studied: [ { plant_id, latin_name, common_name, authorization_level } ] }

function display_NQ14(data){
    
    let container = document.getElementById("invalid-studies");
    container.innerHTML = "";

    for (let scientist of data){
        let checkbox = create_element_from_html(`<input type="checkbox" class="collapsible-checkbox" id="scientist-${scientist.user_id}">`);
        let plants_content = "";
        for (let plant of scientist.plants_studied){
            plants_content += `<div class="plant-invalid-study">
                <span class="plant-id">ID: ${plant.plant_id}</span>
                <span class="plant-latin-name">${format_name(plant.latin_name)}</span>
                <span class="plant-common-name">${format_name(plant.common_name)}</span>
                <span class="access-level level-${plant.authorization_level}">Level ${plant.authorization_level}</span>
            </div>`;
        }
        let label = create_element_from_html(`<label class="collapsible-label" for="scientist-${scientist.user_id}">
            <div class="scientist-data">
                <span> BBI-${scientist.user_id} </span>
                <span> ${format_name(scientist.username)} </span>
                <span class="access-level level-${scientist.authorization_level}">Level ${scientist.authorization_level}</span>
                <span class="material-symbols-outlined expand-icon">expand_more</span>
            </div>
            <div class="collapsible-content"> ${plants_content} </div>
        </label>`);
        
        container.appendChild(checkbox);
        container.appendChild(label);
    }
}

// |====================================================================================================================
// | Q15 - Login
// |====================================================================================================================

function switch_to_login(){
    document.getElementById("reset-form").style.display = "none";
    document.getElementById("login-form").style.display = "block";
}

function exec_NQ15(){
    let login = pad(document.getElementById("login-login").value);
    let password = pad(document.getElementById("login-password").value);
    let data = {login: login, password: password};
    if (pad_method == "not-set"){
        if (data["login"] === undefined) delete data["login"];
        if (data["password"] === undefined) delete data["password"];
    }

    exec("Q15", "/login", POST, data, display_NQ15, "error-scientist-login", display_NQ15_error);
}

function display_NQ15(data){
    if (data === undefined || data.message === undefined || data.authenticated === undefined){
        show_error("error-scientist-login", "error: Response format incorrectly formatted (Check console for details)");
        return;
    }
    if (data.message !== "Authentication successful"){
        show_error("error-scientist-login", "Login failed: " + data.message);
        return;
    }
    if (!data.authenticated){
        show_error("error-scientist-login", "Login failed: data.authenticated is false");
        return;
    }

    show_error("error-scientist-login", "Login successful!", true);
}

function display_NQ15_error(data){
    if (data !== undefined){
        if (data.authenticated === undefined){
            show_error("error-scientist-login", "error: missing data.authenticated in error response");
            return;
        }
        if (data.authenticated){
            show_error("error-scientist-login", "data.authenticated cannot be true on error");
            return;
        }
    }
}

// |====================================================================================================================
// | Q16 - Reset password
// |====================================================================================================================


function switch_to_password_reset(){
    document.getElementById("reset-form").style.display = "block";
    document.getElementById("login-form").style.display = "none";
}

function exec_NQ16(){
    let login = pad(document.getElementById("reset-login").value);
    let password = pad(document.getElementById("reset-password").value);
    let new_password = pad(document.getElementById("reset-new-password").value);
    let data = {login: login, password: password, new_password: new_password};
    if (pad_method == "not-set"){
        if (data["login"] === undefined) delete data["login"];
        if (data["password"] === undefined) delete data["password"];
        if (data["new_password"] === undefined) delete data["new_password"];
    }
    
    exec("Q16", "/update-password", PUT, data, display_NQ16, "error-scientist-login");
}

function display_NQ16(data){
    if (data === undefined || data.message === undefined || data.message !== "Password updated successfully"){
        show_error("error-scientist-login", "error: Response format incorrectly formatted (Check console for details)");
        return;
    }

    show_error("error-scientist-login", "Password updated successfully!", true);
}

